const MagicShardManager = {

  BASE: {
    mana: 100,
    arsmana: 0,
    cooldown: 1,
    spellPower: 6,
    regenera: 1
  },

  SHARDS: {

    "kubejs:mana_crystal": {
      types: ["mana", "arsmana"],
      value: 25,
      attrs: [
        { id: "irons_spellbooks:max_mana", base: 100 },
        { id: "ars_nouveau:ars_nouveau.perk.max_mana", base: 0 }
      ],
      color: "§b",
      text: "Mana"
    },

    "kubejs:cooldown_reduction_crystal": {
      types: ["cooldown"],
      value: 0.03,
      attrs: [
        { id: "irons_spellbooks:cooldown_reduction", base: 1 }
      ],
      color: "§d",
      text: "Cooldown Reduction"
    },

    "kubejs:spell_power_crystal": {
      types: ["spellPower"],
      value: 0.5,
      attrs: [
        { id: "irons_spellbooks:spell_power", base: 6 }
      ],
      color: "§c",
      text: "Spell Power"
    },

    "kubejs:mana_regeneration_crystal": {
      types: ["regenera"],
      value: 0.1,
      attrs: [
        { id: "irons_spellbooks:mana_regen", base: 1 }
      ],
      color: "§d",
      text: "Regeneration"
    }
  },

  getData(server, player) {
    if (!server.persistentData.magicShardBonuses)
      server.persistentData.magicShardBonuses = {}

    const uuid = player.uuid.toString()

    if (!server.persistentData.magicShardBonuses[uuid]) {
      server.persistentData.magicShardBonuses[uuid] = {
        mana: 0,
        arsmana: 0,
        cooldown: 0,
        spellPower: 0,
        regenera: 0
      }
    }

    return server.persistentData.magicShardBonuses[uuid]
  },

  apply(player, server) {
  const data = this.getData(server, player)

  Object.values(this.SHARDS).forEach(shard => {
    shard.attrs.forEach(attr => {

      let bonus = 0

      if (attr.id === "irons_spellbooks:max_mana")
        bonus = data.mana

      if (attr.id === "ars_nouveau:ars_nouveau.perk.max_mana")
        bonus = data.arsmana

      if (attr.id === "irons_spellbooks:cooldown_reduction")
        bonus = data.cooldown

      if (attr.id === "irons_spellbooks:spell_power")
        bonus = data.spellPower

      if (attr.id === "irons_spellbooks:mana_regen")
        bonus = data.regenera

      server.runCommandSilent(
        `attribute ${player.username} ${attr.id} base set ${attr.base + bonus}`
      )
      })
    })
  },

consume(player, server, itemId) {
    const shard = this.SHARDS[itemId]
    if (!shard) return

    const data = this.getData(server, player)

    shard.types.forEach(type => {
      data[type] += shard.value
    })

    this.apply(player, server)

    player.tell(`${shard.color}Crystal ${shard.text} gained!`)
  }
}


ItemEvents.foodEaten(event => {
  MagicShardManager.consume(event.player, event.server, event.item.id)
})

PlayerEvents.loggedIn(event => {
  MagicShardManager.apply(event.player, event.server)
})

PlayerEvents.respawned(event => {
  MagicShardManager.apply(event.player, event.server)
})
